/*
 * Decompiled with CFR 0.152.
 */
package mhzd.net.autoclick.network;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import mhzd.net.autoclick.network.AnnotationScanner;
import mhzd.net.autoclick.network.DynamicData;
import mhzd.net.autoclick.network.NetCodec;
import mhzd.net.autoclick.network.NetHandler;
import mhzd.net.autoclick.network.NetHandlerRoot;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;

public class NetAdapt {
    private final NetCodec codec = new NetCodec();
    private final NetHandlerRoot root = new NetHandlerRoot(this.codec);
    private final Map<String, FMLEventChannel> channels = new HashMap<String, FMLEventChannel>();

    public NetAdapt(String ... channels) {
        for (String name : channels) {
            FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(name);
            channel.register((Object)this.root);
            this.channels.put(name, channel);
        }
    }

    public void register(ASMDataTable table) {
        AnnotationScanner.findPublicStaticMethods(table, NetHandler.Server.class).forEach(method -> {
            NetHandler.Server endPoint = method.getAnnotation(NetHandler.Server.class);
            this.registerMethod((Method)method, (Object)null, endPoint);
        });
        if (FMLLaunchHandler.side().isClient()) {
            AnnotationScanner.findPublicStaticMethods(table, NetHandler.Client.class).forEach(method -> {
                NetHandler.Client endPoint = method.getAnnotation(NetHandler.Client.class);
                this.registerMethod((Method)method, (Object)null, endPoint);
            });
        }
    }

    public void register(Object handler) {
        if (handler instanceof Class) {
            this.registerStatic((Class)handler);
            return;
        }
        for (Method method : handler.getClass().getMethods()) {
            this.tryRegister(handler, method);
        }
    }

    private void tryRegister(@Nullable Object handler, Method method) {
        if (method.isAnnotationPresent(NetHandler.Server.class)) {
            NetHandler.Server endPoint = method.getAnnotation(NetHandler.Server.class);
            this.registerMethod(method, handler, endPoint);
            return;
        }
        if (FMLLaunchHandler.side().isClient() && method.isAnnotationPresent(NetHandler.Client.class)) {
            NetHandler.Client endPoint = method.getAnnotation(NetHandler.Client.class);
            this.registerMethod(method, handler, endPoint);
            return;
        }
    }

    public <T extends DynamicData> void addCodec(Class<T> type, Function<ByteBuf, T> decode) {
        this.codec.registerDynamicClass(type, decode);
    }

    private void registerMethod(Method method, @Nullable Object object, NetHandler.Client endPoint) {
        if (this.channels.containsKey(endPoint.channel())) {
            this.root.registerMethodClient(method, object, endPoint.channel(), endPoint.path());
        }
    }

    private void registerMethod(Method method, @Nullable Object object, NetHandler.Server endPoint) {
        if (this.channels.containsKey(endPoint.channel())) {
            this.root.registerMethodServer(method, object, endPoint.channel(), endPoint.path());
        }
    }

    private void registerStatic(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            this.tryRegister(null, method);
        }
    }

    public void sendToServer(String channel, String path, Object ... data) {
        FMLProxyPacket packet = this.codec.encodeMessage(channel, path, data);
        this.getChannel(channel).sendToServer(packet);
    }

    public void sendToPlayer(EntityPlayerMP player, String channel, String path, Object ... data) {
        FMLProxyPacket packet = this.codec.encodeMessage(channel, path, data);
        this.getChannel(channel).sendTo(packet, player);
    }

    public void sendToAllAround(String channel, String path, NetworkRegistry.TargetPoint point, Object ... data) {
        FMLProxyPacket packet = this.codec.encodeMessage(channel, path, data);
        this.getChannel(channel).sendToAllAround(packet, point);
    }

    public void sendToAll(String channel, String path, Object ... data) {
        FMLProxyPacket packet = this.codec.encodeMessage(channel, path, data);
        this.getChannel(channel).sendToAll(packet);
    }

    private FMLEventChannel getChannel(String name) {
        FMLEventChannel channel = this.channels.get(name);
        if (channel == null) {
            throw new IllegalArgumentException("can't find channel name=" + name);
        }
        return channel;
    }
}

